terraform {
  required_version = ">= 1.0.0, < 2.0.0"
}

variable "names" {
  description = "Lista nazw użytkowników"
  type        = list(string)
  default     = ["neo", "trinity", "morpheus"]
}

output "upper_names" {
  value = [for name in var.names : upper(name)]
}

output "short_upper_names" {
  value = [for name in var.names : upper(name) if length(name) < 5]
}

variable "hero_thousand_faces" {
  description = "map"
  type        = map(string)
  default     = {
    neo      = "bohaterem"
    trinity  = "zakochana"
    morpheus = "mentorem"
  }
}

output "bios" {
  value = [for name, role in var.hero_thousand_faces : "${name} jest ${role}"]
}

output "upper_roles" {
  value = {for name, role in var.hero_thousand_faces : upper(name) => upper(role)}
}

